/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>

#include "udm_config.h"
#include "udm_log.h"
#include "udm_signals.h"


int	have_sighup=0;
int	have_sigterm=0;
int	have_sigpipe=0;
int	have_sigint=0;

#ifdef HAVE_POSIX_SIGNALS

static RETSIGTYPE udm_sig_handler(int signo){
	fprintf(stderr, "\nReceived signal %d!\n", signo);
	switch(signo){
		case SIGHUP:
			have_sighup=1;
			break;
		default:
			exit(1);
	}
}

int UdmSigHandlersInit(UDM_ENV * Env){

    struct  sigaction sa;
    int ret=0;

    sa.sa_handler=udm_sig_handler;
    sa.sa_flags=0;
    sigemptyset(&sa.sa_mask);

    if ((ret=sigaction(SIGTERM, &sa, (struct sigaction *)NULL)))
	UdmLog_noagent(Env, UDM_LOG_WARN, "Can't set sighandler");

    if ((ret=sigaction(SIGHUP, &sa, (struct sigaction *)NULL)))
	UdmLog_noagent(Env, UDM_LOG_WARN, "Can't set sighandler");

    if ((ret=sigaction(SIGPIPE, &sa, (struct sigaction *)NULL)))
	UdmLog_noagent(Env, UDM_LOG_WARN, "Can't set sighandler");

    if (ret+=sigaction(SIGINT, &sa, (struct sigaction *)NULL))
	UdmLog_noagent(Env, UDM_LOG_WARN, "Can't set sighandler");
    return(0);
}

#else /* We have no POSIX signals :( */

int UdmSigHandlersInit(UDM_ENV * Env){
    /* FIXME: implement other type of signal routines */
    return(0);
};

#endif /* HAVE_POSIX_SIGNALS */
